// Modifies direct booking settings to set primary care to 'Yes - Any Veteran'. Will not alter any record where there 
// is already some value set for patientHistoryRequired.
// Run on the var-utility database using "mongo var-utility set-primary-care-support.js" (note that you may need to add
// additional connection/authentication options for your mongo server) or load this script into the mongo client of your
// choice and run against the var-utility database.

var modifiedDocuments = [];
var errors = '';

if (db._name !== 'var-utility') {
    errors += 'Script must be executed on the var-utility database.';
}
else {
    db.directBookingEligibilityCriteria.find().forEach(function (result) {
        var coreSettingIndex;
        var coreSetting;
        var noPatientHistoryRequired;
        var patientHistoryRequiredProperty;
     
        for (coreSettingIndex in (result.coreSettings || [])) {
            coreSetting = result.coreSettings[coreSettingIndex];
            
            if (coreSetting._id === '323' && !coreSetting.hasOwnProperty('patientHistoryRequired')) {
                noPatientHistoryRequired = { };
                patientHistoryRequiredProperty = 'coreSettings.' + coreSettingIndex + '.patientHistoryRequired';
                noPatientHistoryRequired[patientHistoryRequiredProperty] = 'No';
                db.directBookingEligibilityCriteria.update({_id: result._id}, { $set:  noPatientHistoryRequired }); 
                modifiedDocuments.push(result._id);
                break;
            }
        }
    });
}

print('Errors: ' + (errors || 'None'));
print('Modified: ' + (modifiedDocuments.join(', ') || 'None'));
